#include "stdafx.h"
#include "win_demo.h"
#include "DialogRecordPlayback.h"
#include "afxdialogex.h"
#include "sdks.h"
#include "sdks_media.h"
#include "common_struct.h"
#include "perser_json.h"
#include "pack_json.h"

extern int m_handle;
extern int m_chn_option;
extern int m_pb_stream_id;
IMPLEMENT_DYNAMIC(CDialogRecordPlayback, CDialogEx)

CDialogRecordPlayback::CDialogRecordPlayback(CWnd* pParent /*=NULL*/)
	: CDialogEx(IDD_DIALOG_RECORD_PLAYBACK, pParent)
{

}

CDialogRecordPlayback::~CDialogRecordPlayback()
{
}

void CDialogRecordPlayback::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_BTN_PB_VIDEO, m_pb_video);
	DDX_Control(pDX, IDC_LIST_PB_RECORD, m_pb_search_list);
	DDX_Control(pDX, IDC_DATE_PB_START, m_pb_start_date);
	DDX_Control(pDX, IDC_DATE_PB_END, m_pb_end_date);
	DDX_Control(pDX, IDC_DATE_PB_JUMP, m_pb_jump_date);
	DDX_Control(pDX, IDC_TIME_PB_JUMP, m_pb_jump_time);
	DDX_Control(pDX, IDC_COMBO_MULTI, m_pb_multi);
}

BOOL CDialogRecordPlayback::OnInitRecordPlayback()
{
	DWORD dwStyle = m_pb_search_list.GetExtendedStyle();
	dwStyle |= LVS_EX_FULLROWSELECT;
	dwStyle |= LVS_EX_GRIDLINES;
	//dwStyle |= LVS_EX_CHECKBOXES;
	m_pb_search_list.SetExtendedStyle(dwStyle);
	//dwStyle |= LVS_EX_FULLROWSELECT;
	m_pb_search_list.ModifyStyle(LVS_ICON | LVS_SMALLICON | LVS_LIST, LVS_REPORT);
	//m_pb_search_list.SetExtendedStyle(LVS_EX_GRIDLINES);
	m_pb_search_list.DeleteAllItems();
	m_pb_search_list.InsertColumn(0, _T("Serial number"), LVCFMT_LEFT, 80);
	m_pb_search_list.InsertColumn(1, _T("Start time"), LVCFMT_LEFT, 260);
	m_pb_search_list.InsertColumn(2, _T("End time"), LVCFMT_LEFT, 220);
	m_pb_search_list.InsertColumn(3, _T("Note"), LVCFMT_LEFT, 142);
	
	m_pb_multi.InsertString(0, TEXT("1"));
	m_pb_multi.InsertString(1, TEXT("2"));
	m_pb_multi.InsertString(2, TEXT("4"));
	m_pb_multi.InsertString(3, TEXT("8"));
	m_pb_multi.SetCurSel(0);
	return TRUE;
}

BEGIN_MESSAGE_MAP(CDialogRecordPlayback, CDialogEx)
	ON_BN_CLICKED(IDC_BTN_RECORD_PLAY, &CDialogRecordPlayback::OnBnClickedBtnRecordPlay)
	ON_BN_CLICKED(IDC_BTN_SEARCH, &CDialogRecordPlayback::OnBnClickedBtnSearch)
	ON_NOTIFY(NM_CLICK, IDC_LIST_PB_RECORD, &CDialogRecordPlayback::OnClickListPbRecord)
	ON_NOTIFY(NM_DBLCLK, IDC_LIST_PB_RECORD, &CDialogRecordPlayback::OnDBlickListPbRecord)
	ON_BN_CLICKED(IDC_BTN_PB_JUMP_PLAY, &CDialogRecordPlayback::OnBnClickedBtnPbJumpPlay)
	ON_BN_CLICKED(IDC_BTN_RECORD_PAUSE, &CDialogRecordPlayback::OnBnClickedBtnRecordPause)
	ON_BN_CLICKED(IDC_BTN_RECORD_STOP, &CDialogRecordPlayback::OnBnClickedBtnRecordStop)
	ON_BN_CLICKED(IDC_BTN_RECORD_MULTI, &CDialogRecordPlayback::OnBnClickedBtnRecordSpeed)
END_MESSAGE_MAP()


jy_dev_pb_rec_list_t stPBRecordList = { 0 };
void CDialogRecordPlayback::OnBnClickedBtnSearch()
{
	char *p_result = NULL;
	CString str_temp;
	int nRow = 0;
	char start_time[24] = { 0 };
	char end_time[24] = { 0 };
	CTime tm;
	m_pb_start_date.GetTime(tm);
	CString strDate = tm.Format("%Y-%m-%d");
	memset(&start_time, 0, sizeof(start_time));
	sprintf(start_time, "%s 00:00:00", strDate.GetBuffer(strDate.GetLength() + 1));
	m_pb_end_date.GetTime(tm);
	strDate = tm.Format("%Y-%m-%d");
	memset(&end_time, 0, sizeof(end_time));
	sprintf(end_time, "%s 23:59:59", strDate.GetBuffer(strDate.GetLength() + 1));
	int nRet = sdks_dev_pb_get_rec_list(m_handle, m_chn_option, 1, start_time, &p_result);
	if (!nRet)
	{
		memset(&stPBRecordList, 0, sizeof(jy_dev_pb_rec_list_t));
		json_parser_pb_rec_list(p_result, &stPBRecordList);
	}
	m_pb_search_list.DeleteAllItems();
	for (int i = 0; i < stPBRecordList.num; ++i)
	{
		str_temp.Format(_T("%d"), i + 1);
		nRow = m_pb_search_list.InsertItem(i, str_temp);
		m_pb_search_list.SetItemText(nRow, 1, stPBRecordList.pb_rec_list[i].start_time);
		m_pb_search_list.SetItemText(nRow, 2, stPBRecordList.pb_rec_list[i].end_time);
	}
}

void CDialogRecordPlayback::OnClickListPbRecord(NMHDR *pNMHDR, LRESULT *pResult)
{
	LPNMITEMACTIVATE pNMItemActivate = reinterpret_cast<LPNMITEMACTIVATE>(pNMHDR);
	int nYear, nMonth, nDay, nHour, nMinute, nSecond = 0;
	POSITION pos = m_pb_search_list.GetFirstSelectedItemPosition();
	if (NULL != pos)
	{
		int row = (int)m_pb_search_list.GetNextSelectedItem(pos);
		sscanf(stPBRecordList.pb_rec_list[row].start_time, "%d-%d-%d %d:%d:%d", &nYear, &nMonth, &nDay, &nHour, &nMinute, &nSecond);
		CTime T1(nYear, nMonth, nDay, nHour, nMinute, nSecond);
		m_pb_jump_date.SetTime(&T1);
		m_pb_jump_time.SetTime(&T1);
	}
	*pResult = 0;
}

void CDialogRecordPlayback::OnDBlickListPbRecord(NMHDR *pNMHDR, LRESULT *pResult)
{
	LPNMITEMACTIVATE pNMItemActivate = reinterpret_cast<LPNMITEMACTIVATE>(pNMHDR);
	int row = 0;
	int nYear, nMonth, nDay, nHour, nMinute, nSecond = 0;
	POSITION pos = m_pb_search_list.GetFirstSelectedItemPosition();
	if (NULL != pos)
	{
		row = (int)m_pb_search_list.GetNextSelectedItem(pos);
		sscanf(stPBRecordList.pb_rec_list[row].start_time, "%d-%d-%d %d:%d:%d", &nYear, &nMonth, &nDay, &nHour, &nMinute, &nSecond);
		CTime T1(nYear, nMonth, nDay, nHour, nMinute, nSecond);
		m_pb_jump_date.SetTime(&T1);
		m_pb_jump_time.SetTime(&T1);
	}
	HWND hwnd = m_pb_video.GetSafeHwnd();
	if (m_pb_stream_id)
	{
		sdks_md_pb_stop(m_handle, m_pb_stream_id);
		m_pb_stream_id = 0;
	}
	m_pb_stream_id = sdks_md_pb_start(m_handle, m_chn_option, 1, stPBRecordList.pb_rec_list[row].start_time, hwnd, true, NULL, NULL);
	*pResult = 0;
}

void CDialogRecordPlayback::OnBnClickedBtnPbJumpPlay()
{
	CTime tm;
	char pb_jump_time[24] = { 0 };
	m_pb_jump_date.GetTime(tm);
	CString strDate = tm.Format("%Y-%m-%d");
	m_pb_jump_time.GetTime(tm);
	CString strTime = tm.Format("%H:%M:%S");
	memset(&pb_jump_time, 0, sizeof(pb_jump_time));
	sprintf(pb_jump_time, "%s %s", strDate.GetBuffer(strDate.GetLength() + 1), strTime.GetBuffer(strTime.GetLength() + 1));
	HWND hwnd = m_pb_video.GetSafeHwnd();
	if (m_pb_stream_id)
	{
		sdks_md_pb_stop(m_handle, m_pb_stream_id);
		m_pb_stream_id = 0;
	}
	m_pb_stream_id = sdks_md_pb_start(m_handle, m_chn_option, 1, pb_jump_time, hwnd, false, NULL, NULL);
}

void CDialogRecordPlayback::OnBnClickedBtnRecordPlay()
{
	if (m_pb_stream_id)
	{
		sdks_md_pb_resume(m_handle, m_pb_stream_id);
	}
}

void CDialogRecordPlayback::OnBnClickedBtnRecordSpeed()
{
	if (m_pb_stream_id)
	{
		CString str_speed;
		int speed_index = m_pb_multi.GetCurSel();
		m_pb_multi.GetLBText(speed_index, str_speed);
		int speed = _ttoi(str_speed);
		sdks_md_set_pb_speed(m_handle, m_pb_stream_id, speed);
	}
}

void CDialogRecordPlayback::OnBnClickedBtnRecordPause()
{
	if (m_pb_stream_id)
	{
		sdks_md_pb_pause(m_handle, m_pb_stream_id);
	}
}


void CDialogRecordPlayback::OnBnClickedBtnRecordStop()
{
	if (m_pb_stream_id)
	{
		sdks_md_pb_stop(m_handle, m_pb_stream_id);
		m_pb_stream_id = 0;
	}
}
